/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.stats;

import appeng.core.AppEng;
import appeng.core.stats.IAdvancementTrigger;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class AppEngAdvancementTrigger
implements CriterionTrigger<Instance>,
IAdvancementTrigger {
    private final ResourceLocation id;
    private final Map<PlayerAdvancements, Listeners> listeners = new HashMap<PlayerAdvancements, Listeners>();

    public AppEngAdvancementTrigger(String id) {
        this.id = AppEng.makeId(id);
    }

    public Instance instance() {
        return new Instance(this.id);
    }

    public ResourceLocation m_7295_() {
        return this.id;
    }

    public void m_6467_(PlayerAdvancements playerAdvancementsIn, CriterionTrigger.Listener<Instance> listener) {
        Listeners l = this.listeners.get(playerAdvancementsIn);
        if (l == null) {
            l = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, l);
        }
        l.add(listener);
    }

    public void m_6468_(PlayerAdvancements playerAdvancementsIn, CriterionTrigger.Listener<Instance> listener) {
        Listeners l = this.listeners.get(playerAdvancementsIn);
        if (l != null) {
            l.remove(listener);
            if (l.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void m_5656_(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Instance createInstance(JsonObject object, DeserializationContext conditions) {
        return new Instance(this.m_7295_());
    }

    @Override
    public void trigger(ServerPlayer parPlayer) {
        Listeners l = this.listeners.get(parPlayer.m_8960_());
        if (l != null) {
            l.trigger((Player)parPlayer);
        }
    }

    public static class Instance
    implements CriterionTriggerInstance {
        private final ResourceLocation id;

        public Instance(ResourceLocation id) {
            this.id = id;
        }

        public boolean test() {
            return true;
        }

        public ResourceLocation m_7294_() {
            return this.id;
        }

        public JsonObject m_7683_(SerializationContext conditions) {
            return new JsonObject();
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<CriterionTrigger.Listener<Instance>> listeners = new HashSet<CriterionTrigger.Listener<Instance>>();

        Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(CriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(CriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(Player player) {
            ArrayList<CriterionTrigger.Listener<Instance>> list = null;
            for (CriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.m_13685_()).test()) continue;
                if (list == null) {
                    list = new ArrayList<CriterionTrigger.Listener<Instance>>();
                }
                list.add(listener);
            }
            if (list != null) {
                for (CriterionTrigger.Listener listener : list) {
                    listener.m_13686_(this.playerAdvancements);
                }
            }
        }
    }
}

